/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter1;

public abstract class QueryIterProcessBinding
extends QueryIter1 {
    private Binding nextBinding = null;
    private final AtomicBoolean signalCancel;

    public abstract Binding accept(Binding var1);

    public QueryIterProcessBinding(QueryIterator qIter, ExecutionContext context2) {
        super(qIter, context2);
        AtomicBoolean signal;
        try {
            signal = context2.getCancelSignal();
        }
        catch (Exception ex) {
            signal = null;
        }
        this.signalCancel = signal;
    }

    @Override
    protected boolean hasNextBinding() {
        if (this.isFinished()) {
            return false;
        }
        if (this.nextBinding != null) {
            return true;
        }
        if (this.getInput() == null) {
            throw new ARQInternalErrorException(Lib.className(this) + ": Null iterator");
        }
        while (this.getInput().hasNext()) {
            this.checkCancelled();
            Binding input = this.getInput().nextBinding();
            Binding output = this.accept(input);
            if (output == null) continue;
            this.nextBinding = output;
            return true;
        }
        this.nextBinding = null;
        return false;
    }

    private final void checkCancelled() {
        if (this.signalCancel != null && this.signalCancel.get()) {
            this.cancel();
            throw new QueryCancelledException();
        }
    }

    @Override
    public Binding moveToNextBinding() {
        if (this.hasNext()) {
            Binding r = this.nextBinding;
            this.nextBinding = null;
            return r;
        }
        throw new NoSuchElementException();
    }

    @Override
    protected void closeSubIterator() {
    }

    @Override
    protected void requestSubCancel() {
    }
}

