/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.index.ext;

import java.nio.ByteBuffer;
import org.apache.jena.tdb1.base.block.Block;
import org.apache.jena.tdb1.base.block.BlockConverter;
import org.apache.jena.tdb1.base.block.BlockMgr;
import org.apache.jena.tdb1.base.block.BlockType;
import org.apache.jena.tdb1.base.page.PageBlockMgr;
import org.apache.jena.tdb1.base.record.RecordException;
import org.apache.jena.tdb1.base.record.RecordFactory;
import org.apache.jena.tdb1.index.ext.HashBucket;

public class HashBucketMgr
extends PageBlockMgr<HashBucket> {
    public HashBucketMgr(RecordFactory factory, BlockMgr blockMgr) {
        super(null, blockMgr);
        Block2HashBucketMgr conv = new Block2HashBucketMgr(factory);
        super.setConverter(conv);
    }

    public HashBucket create(int hash, int hashBitLen) {
        HashBucket bucket = (HashBucket)super.create(BlockType.RECORD_BLOCK);
        bucket.setTrieValue(hash);
        bucket.setTrieLength(hashBitLen);
        return bucket;
    }

    @Override
    public HashBucket getWrite(int id) {
        HashBucket page = this._get(id);
        page.getBackingBlock().setModified(true);
        return page;
    }

    @Override
    public HashBucket getRead(int id) {
        return this._get(id);
    }

    public HashBucket get(int id) {
        return this.getWrite(id);
    }

    public HashBucket _get(int id) {
        HashBucket bucket = (HashBucket)super.getWrite(id);
        return bucket;
    }

    private static class Block2HashBucketMgr
    implements BlockConverter<HashBucket> {
        private RecordFactory factory;

        Block2HashBucketMgr(RecordFactory factory) {
            this.factory = factory;
        }

        @Override
        public HashBucket createFromBlock(Block block, BlockType blkType) {
            if (blkType != BlockType.RECORD_BLOCK) {
                throw new RecordException("Not RECORD_BLOCK: " + String.valueOf(blkType));
            }
            HashBucket bucket = HashBucket.createBlank(block, this.factory);
            return bucket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HashBucket fromBlock(Block block) {
            Block block2 = block;
            synchronized (block2) {
                HashBucket bucket = HashBucket.format(block, this.factory);
                return bucket;
            }
        }

        @Override
        public Block toBlock(HashBucket bucket) {
            int count = bucket.getRecordBuffer().size();
            ByteBuffer bb = bucket.getBackingBlock().getByteBuffer();
            bb.putInt(0, bucket.getCount());
            bb.putInt(4, bucket.getTrieValue());
            bb.putInt(8, bucket.getTrieBitLen());
            return bucket.getBackingBlock();
        }
    }
}

