/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance3d;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;

public class AxisPlaneCoordinateSequence
implements CoordinateSequence {
    private static final int[] XY_INDEX = new int[]{0, 1};
    private static final int[] XZ_INDEX = new int[]{0, 2};
    private static final int[] YZ_INDEX = new int[]{1, 2};
    private CoordinateSequence seq;
    private int[] indexMap;

    public static CoordinateSequence projectToXY(CoordinateSequence seq2) {
        return new AxisPlaneCoordinateSequence(seq2, XY_INDEX);
    }

    public static CoordinateSequence projectToXZ(CoordinateSequence seq2) {
        return new AxisPlaneCoordinateSequence(seq2, XZ_INDEX);
    }

    public static CoordinateSequence projectToYZ(CoordinateSequence seq2) {
        return new AxisPlaneCoordinateSequence(seq2, YZ_INDEX);
    }

    private AxisPlaneCoordinateSequence(CoordinateSequence seq2, int[] indexMap) {
        this.seq = seq2;
        this.indexMap = indexMap;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Coordinate getCoordinate(int i) {
        return this.getCoordinateCopy(i);
    }

    @Override
    public Coordinate getCoordinateCopy(int i) {
        return new Coordinate(this.getX(i), this.getY(i), this.getZ(i));
    }

    @Override
    public void getCoordinate(int index, Coordinate coord) {
        coord.x = this.getOrdinate(index, 0);
        coord.y = this.getOrdinate(index, 1);
        coord.setZ(this.getOrdinate(index, 2));
    }

    @Override
    public double getX(int index) {
        return this.getOrdinate(index, 0);
    }

    @Override
    public double getY(int index) {
        return this.getOrdinate(index, 1);
    }

    @Override
    public double getZ(int index) {
        return this.getOrdinate(index, 2);
    }

    @Override
    public double getOrdinate(int index, int ordinateIndex) {
        if (ordinateIndex > 1) {
            return 0.0;
        }
        return this.seq.getOrdinate(index, this.indexMap[ordinateIndex]);
    }

    @Override
    public int size() {
        return this.seq.size();
    }

    @Override
    public void setOrdinate(int index, int ordinateIndex, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Coordinate[] toCoordinateArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Envelope expandEnvelope(Envelope env) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AxisPlaneCoordinateSequence copy() {
        throw new UnsupportedOperationException();
    }
}

