/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.xmlrpc;

import java.security.Permission;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.auth.permissions.WikiPermission;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.xmlrpc.WikiRPCHandler;
import org.apache.xmlrpc.AuthenticationFailed;

public abstract class AbstractRPCHandler
implements WikiRPCHandler {
    public static final int ERR_NOPAGE = 1;
    public static final int ERR_NOPERMISSION = 2;
    public static final String LINK_LOCAL = "local";
    public static final String LINK_EXTERNAL = "external";
    public static final String LINK_INLINE = "inline";
    protected Engine m_engine;
    protected Context m_context;
    public static final int RPC_VERSION = 1;

    @Override
    public void initialize(Context context) {
        this.m_context = context;
        this.m_engine = context.getEngine();
    }

    protected abstract Hashtable encodeWikiPage(Page var1);

    public Vector getRecentChanges(Date since) {
        this.checkPermission(PagePermission.VIEW);
        Set<Page> pages = ((PageManager)this.m_engine.getManager(PageManager.class)).getRecentChanges();
        Vector<Hashtable> result = new Vector<Hashtable>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(since);
        cal.add(14, cal.get(15) + (cal.getTimeZone().inDaylightTime(since) ? cal.get(16) : 0));
        for (Page page : pages) {
            if (!page.getLastModified().after(cal.getTime())) continue;
            result.add(this.encodeWikiPage(page));
        }
        return result;
    }

    protected void checkPermission(Permission perm) {
        AuthorizationManager mgr = (AuthorizationManager)this.m_engine.getManager(AuthorizationManager.class);
        if (mgr.checkPermission(this.m_context.getWikiSession(), perm)) {
            return;
        }
        throw new AuthenticationFailed("You have no access to this resource, o master");
    }

    public int getRPCVersionSupported() {
        this.checkPermission(WikiPermission.LOGIN);
        return 1;
    }
}

