/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tasks.auth;

import java.util.Locale;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.i18n.InternationalizationManager;
import org.apache.wiki.util.HttpUtil;
import org.apache.wiki.util.MailUtil;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.Task;

public class SaveUserProfileTask
extends Task {
    private static final long serialVersionUID = 6994297086560480285L;
    private static final Logger LOG = LogManager.getLogger(SaveUserProfileTask.class);
    private final Locale m_loc;

    public SaveUserProfileTask(Locale loc) {
        super("task.createUserProfile");
        this.m_loc = loc;
    }

    @Override
    public Outcome execute(Context context) throws WikiException {
        UserProfile profile = (UserProfile)this.getWorkflowContext().get("userProfile");
        ((UserManager)context.getEngine().getManager(UserManager.class)).getUserDatabase().save(profile);
        if (profile != null && profile.getEmail() != null) {
            try {
                InternationalizationManager i18n = (InternationalizationManager)context.getEngine().getManager(InternationalizationManager.class);
                String app = context.getEngine().getApplicationName();
                String to = profile.getEmail();
                String subject = i18n.get("templates.default", this.m_loc, "notification.createUserProfile.accept.subject", app);
                String loginUrl = context.getEngine().getURL(ContextEnum.WIKI_LOGIN.getRequestContext(), null, null);
                String absoluteLoginUrl = HttpUtil.getAbsoluteUrl((HttpServletRequest)context.getHttpRequest(), (String)loginUrl);
                String content = i18n.get("templates.default", this.m_loc, "notification.createUserProfile.accept.content", app, profile.getLoginName(), profile.getFullname(), profile.getEmail(), absoluteLoginUrl);
                MailUtil.sendMessage((Properties)context.getEngine().getWikiProperties(), (String)to, (String)subject, (String)content);
            }
            catch (AddressException e) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
            catch (MessagingException me) {
                LOG.error("Could not send registration confirmation e-mail. Is the e-mail server running?", (Throwable)me);
            }
        }
        return Outcome.STEP_COMPLETE;
    }
}

