/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiServiceRef;
import com.cloudera.api.swagger.model.HBaseDatabaseArgs;
import com.cloudera.api.swagger.model.HBasePeerState;
import com.cloudera.api.swagger.model.HBaseTableArgs;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Schema(description="Replication arguments for HBase service")
public class ApiHBaseReplicationArguments {
    @SerializedName(value="sourceHBaseService")
    private ApiServiceRef sourceHBaseService = null;
    @SerializedName(value="peerState")
    private HBasePeerState peerState = null;
    @SerializedName(value="hbasePeerId")
    private String hbasePeerId = null;
    @SerializedName(value="hbaseClusterKey")
    private String hbaseClusterKey = null;
    @SerializedName(value="endPointClassName")
    private String endPointClassName = null;
    @SerializedName(value="tables")
    private List<HBaseTableArgs> tables = null;
    @SerializedName(value="database")
    private HBaseDatabaseArgs database = null;
    @SerializedName(value="replicationProperties")
    private Map<String, String> replicationProperties = null;
    @SerializedName(value="sourceAccount")
    private String sourceAccount = null;
    @SerializedName(value="sourceSchedulerPool")
    private String sourceSchedulerPool = null;
    @SerializedName(value="numMappers")
    private BigDecimal numMappers = null;
    @SerializedName(value="bandwidthPerMap")
    private BigDecimal bandwidthPerMap = null;
    @SerializedName(value="exportSnapshotUser")
    private String exportSnapshotUser = null;
    @SerializedName(value="snapshotScratchLocation")
    private String snapshotScratchLocation = null;
    @SerializedName(value="validateReplicationSetup")
    private Boolean validateReplicationSetup = null;
    @SerializedName(value="maxParallelSnapshots")
    private BigDecimal maxParallelSnapshots = null;

    public ApiHBaseReplicationArguments sourceHBaseService(ApiServiceRef sourceHBaseService) {
        this.sourceHBaseService = sourceHBaseService;
        return this;
    }

    @Schema(description="")
    public ApiServiceRef getSourceHBaseService() {
        return this.sourceHBaseService;
    }

    public void setSourceHBaseService(ApiServiceRef sourceHBaseService) {
        this.sourceHBaseService = sourceHBaseService;
    }

    public ApiHBaseReplicationArguments peerState(HBasePeerState peerState) {
        this.peerState = peerState;
        return this;
    }

    @Schema(description="")
    public HBasePeerState getPeerState() {
        return this.peerState;
    }

    public void setPeerState(HBasePeerState peerState) {
        this.peerState = peerState;
    }

    public ApiHBaseReplicationArguments hbasePeerId(String hbasePeerId) {
        this.hbasePeerId = hbasePeerId;
        return this;
    }

    @Schema(description="Available since API v52.")
    public String getHbasePeerId() {
        return this.hbasePeerId;
    }

    public void setHbasePeerId(String hbasePeerId) {
        this.hbasePeerId = hbasePeerId;
    }

    public ApiHBaseReplicationArguments hbaseClusterKey(String hbaseClusterKey) {
        this.hbaseClusterKey = hbaseClusterKey;
        return this;
    }

    @Schema(description="")
    public String getHbaseClusterKey() {
        return this.hbaseClusterKey;
    }

    public void setHbaseClusterKey(String hbaseClusterKey) {
        this.hbaseClusterKey = hbaseClusterKey;
    }

    public ApiHBaseReplicationArguments endPointClassName(String endPointClassName) {
        this.endPointClassName = endPointClassName;
        return this;
    }

    @Schema(description="")
    public String getEndPointClassName() {
        return this.endPointClassName;
    }

    public void setEndPointClassName(String endPointClassName) {
        this.endPointClassName = endPointClassName;
    }

    public ApiHBaseReplicationArguments tables(List<HBaseTableArgs> tables) {
        this.tables = tables;
        return this;
    }

    public ApiHBaseReplicationArguments addTablesItem(HBaseTableArgs tablesItem) {
        if (this.tables == null) {
            this.tables = new ArrayList<HBaseTableArgs>();
        }
        this.tables.add(tablesItem);
        return this;
    }

    @Schema(description="")
    public List<HBaseTableArgs> getTables() {
        return this.tables;
    }

    public void setTables(List<HBaseTableArgs> tables) {
        this.tables = tables;
    }

    public ApiHBaseReplicationArguments database(HBaseDatabaseArgs database) {
        this.database = database;
        return this;
    }

    @Schema(description="")
    public HBaseDatabaseArgs getDatabase() {
        return this.database;
    }

    public void setDatabase(HBaseDatabaseArgs database) {
        this.database = database;
    }

    public ApiHBaseReplicationArguments replicationProperties(Map<String, String> replicationProperties) {
        this.replicationProperties = replicationProperties;
        return this;
    }

    public ApiHBaseReplicationArguments putReplicationPropertiesItem(String key, String replicationPropertiesItem) {
        if (this.replicationProperties == null) {
            this.replicationProperties = new HashMap<String, String>();
        }
        this.replicationProperties.put(key, replicationPropertiesItem);
        return this;
    }

    @Schema(description="")
    public Map<String, String> getReplicationProperties() {
        return this.replicationProperties;
    }

    public void setReplicationProperties(Map<String, String> replicationProperties) {
        this.replicationProperties = replicationProperties;
    }

    public ApiHBaseReplicationArguments sourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
        return this;
    }

    @Schema(description="")
    public String getSourceAccount() {
        return this.sourceAccount;
    }

    public void setSourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public ApiHBaseReplicationArguments sourceSchedulerPool(String sourceSchedulerPool) {
        this.sourceSchedulerPool = sourceSchedulerPool;
        return this;
    }

    @Schema(description="")
    public String getSourceSchedulerPool() {
        return this.sourceSchedulerPool;
    }

    public void setSourceSchedulerPool(String sourceSchedulerPool) {
        this.sourceSchedulerPool = sourceSchedulerPool;
    }

    public ApiHBaseReplicationArguments numMappers(BigDecimal numMappers) {
        this.numMappers = numMappers;
        return this;
    }

    @Schema(description="")
    public BigDecimal getNumMappers() {
        return this.numMappers;
    }

    public void setNumMappers(BigDecimal numMappers) {
        this.numMappers = numMappers;
    }

    public ApiHBaseReplicationArguments bandwidthPerMap(BigDecimal bandwidthPerMap) {
        this.bandwidthPerMap = bandwidthPerMap;
        return this;
    }

    @Schema(description="")
    public BigDecimal getBandwidthPerMap() {
        return this.bandwidthPerMap;
    }

    public void setBandwidthPerMap(BigDecimal bandwidthPerMap) {
        this.bandwidthPerMap = bandwidthPerMap;
    }

    public ApiHBaseReplicationArguments exportSnapshotUser(String exportSnapshotUser) {
        this.exportSnapshotUser = exportSnapshotUser;
        return this;
    }

    @Schema(description="")
    public String getExportSnapshotUser() {
        return this.exportSnapshotUser;
    }

    public void setExportSnapshotUser(String exportSnapshotUser) {
        this.exportSnapshotUser = exportSnapshotUser;
    }

    public ApiHBaseReplicationArguments snapshotScratchLocation(String snapshotScratchLocation) {
        this.snapshotScratchLocation = snapshotScratchLocation;
        return this;
    }

    @Schema(description="")
    public String getSnapshotScratchLocation() {
        return this.snapshotScratchLocation;
    }

    public void setSnapshotScratchLocation(String snapshotScratchLocation) {
        this.snapshotScratchLocation = snapshotScratchLocation;
    }

    public ApiHBaseReplicationArguments validateReplicationSetup(Boolean validateReplicationSetup) {
        this.validateReplicationSetup = validateReplicationSetup;
        return this;
    }

    @Schema(description="")
    public Boolean isValidateReplicationSetup() {
        return this.validateReplicationSetup;
    }

    public void setValidateReplicationSetup(Boolean validateReplicationSetup) {
        this.validateReplicationSetup = validateReplicationSetup;
    }

    public ApiHBaseReplicationArguments maxParallelSnapshots(BigDecimal maxParallelSnapshots) {
        this.maxParallelSnapshots = maxParallelSnapshots;
        return this;
    }

    @Schema(description="")
    public BigDecimal getMaxParallelSnapshots() {
        return this.maxParallelSnapshots;
    }

    public void setMaxParallelSnapshots(BigDecimal maxParallelSnapshots) {
        this.maxParallelSnapshots = maxParallelSnapshots;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHBaseReplicationArguments apiHBaseReplicationArguments = (ApiHBaseReplicationArguments)o;
        return Objects.equals(this.sourceHBaseService, apiHBaseReplicationArguments.sourceHBaseService) && Objects.equals((Object)this.peerState, (Object)apiHBaseReplicationArguments.peerState) && Objects.equals(this.hbasePeerId, apiHBaseReplicationArguments.hbasePeerId) && Objects.equals(this.hbaseClusterKey, apiHBaseReplicationArguments.hbaseClusterKey) && Objects.equals(this.endPointClassName, apiHBaseReplicationArguments.endPointClassName) && Objects.equals(this.tables, apiHBaseReplicationArguments.tables) && Objects.equals(this.database, apiHBaseReplicationArguments.database) && Objects.equals(this.replicationProperties, apiHBaseReplicationArguments.replicationProperties) && Objects.equals(this.sourceAccount, apiHBaseReplicationArguments.sourceAccount) && Objects.equals(this.sourceSchedulerPool, apiHBaseReplicationArguments.sourceSchedulerPool) && Objects.equals(this.numMappers, apiHBaseReplicationArguments.numMappers) && Objects.equals(this.bandwidthPerMap, apiHBaseReplicationArguments.bandwidthPerMap) && Objects.equals(this.exportSnapshotUser, apiHBaseReplicationArguments.exportSnapshotUser) && Objects.equals(this.snapshotScratchLocation, apiHBaseReplicationArguments.snapshotScratchLocation) && Objects.equals(this.validateReplicationSetup, apiHBaseReplicationArguments.validateReplicationSetup) && Objects.equals(this.maxParallelSnapshots, apiHBaseReplicationArguments.maxParallelSnapshots);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceHBaseService, this.peerState, this.hbasePeerId, this.hbaseClusterKey, this.endPointClassName, this.tables, this.database, this.replicationProperties, this.sourceAccount, this.sourceSchedulerPool, this.numMappers, this.bandwidthPerMap, this.exportSnapshotUser, this.snapshotScratchLocation, this.validateReplicationSetup, this.maxParallelSnapshots});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHBaseReplicationArguments {\n");
        sb.append("    sourceHBaseService: ").append(this.toIndentedString(this.sourceHBaseService)).append("\n");
        sb.append("    peerState: ").append(this.toIndentedString((Object)this.peerState)).append("\n");
        sb.append("    hbasePeerId: ").append(this.toIndentedString(this.hbasePeerId)).append("\n");
        sb.append("    hbaseClusterKey: ").append(this.toIndentedString(this.hbaseClusterKey)).append("\n");
        sb.append("    endPointClassName: ").append(this.toIndentedString(this.endPointClassName)).append("\n");
        sb.append("    tables: ").append(this.toIndentedString(this.tables)).append("\n");
        sb.append("    database: ").append(this.toIndentedString(this.database)).append("\n");
        sb.append("    replicationProperties: ").append(this.toIndentedString(this.replicationProperties)).append("\n");
        sb.append("    sourceAccount: ").append(this.toIndentedString(this.sourceAccount)).append("\n");
        sb.append("    sourceSchedulerPool: ").append(this.toIndentedString(this.sourceSchedulerPool)).append("\n");
        sb.append("    numMappers: ").append(this.toIndentedString(this.numMappers)).append("\n");
        sb.append("    bandwidthPerMap: ").append(this.toIndentedString(this.bandwidthPerMap)).append("\n");
        sb.append("    exportSnapshotUser: ").append(this.toIndentedString(this.exportSnapshotUser)).append("\n");
        sb.append("    snapshotScratchLocation: ").append(this.toIndentedString(this.snapshotScratchLocation)).append("\n");
        sb.append("    validateReplicationSetup: ").append(this.toIndentedString(this.validateReplicationSetup)).append("\n");
        sb.append("    maxParallelSnapshots: ").append(this.toIndentedString(this.maxParallelSnapshots)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

