/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode.instruction;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.BytecodeVisitor;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.OpCode;
import io.airlift.bytecode.instruction.InstructionNode;
import io.airlift.bytecode.instruction.LabelNode;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class JumpInstruction
implements InstructionNode {
    private final OpCode opCode;
    private final LabelNode label;

    public static InstructionNode jump(LabelNode label) {
        return new JumpInstruction(OpCode.GOTO, label);
    }

    public static InstructionNode jumpIfEqualZero(LabelNode label) {
        return new JumpInstruction(OpCode.IFEQ, label);
    }

    public static InstructionNode jumpIfNotEqualZero(LabelNode label) {
        return new JumpInstruction(OpCode.IFNE, label);
    }

    public static InstructionNode jumpIfLessThanZero(LabelNode label) {
        return new JumpInstruction(OpCode.IFLT, label);
    }

    public static InstructionNode jumpIfGreaterThanZero(LabelNode label) {
        return new JumpInstruction(OpCode.IFGT, label);
    }

    public static InstructionNode jumpIfLessThanOrEqualZero(LabelNode label) {
        return new JumpInstruction(OpCode.IFLE, label);
    }

    public static InstructionNode jumpIfIntGreaterThanOrEqualZero(LabelNode label) {
        return new JumpInstruction(OpCode.IFGE, label);
    }

    public static InstructionNode jumpIfIntEqual(LabelNode label) {
        return new JumpInstruction(OpCode.IF_ICMPEQ, label);
    }

    public static InstructionNode jumpIfIntNotEqual(LabelNode label) {
        return new JumpInstruction(OpCode.IF_ICMPNE, label);
    }

    public static InstructionNode jumpIfIntLessThan(LabelNode label) {
        return new JumpInstruction(OpCode.IF_ICMPLT, label);
    }

    public static InstructionNode jumpIfIntGreaterThan(LabelNode label) {
        return new JumpInstruction(OpCode.IF_ICMPGT, label);
    }

    public static InstructionNode jumpIfIntLessThanOrEqual(LabelNode label) {
        return new JumpInstruction(OpCode.IF_ICMPLE, label);
    }

    public static InstructionNode jumpIfNull(LabelNode label) {
        return new JumpInstruction(OpCode.IFNULL, label);
    }

    public static InstructionNode jumpIfNotNull(LabelNode label) {
        return new JumpInstruction(OpCode.IFNONNULL, label);
    }

    public static InstructionNode jumpIfObjectSame(LabelNode label) {
        return new JumpInstruction(OpCode.IF_ACMPEQ, label);
    }

    public static InstructionNode jumpIfObjectNotSame(LabelNode label) {
        return new JumpInstruction(OpCode.IF_ACMPNE, label);
    }

    public JumpInstruction(OpCode opCode, LabelNode label) {
        this.opCode = opCode;
        this.label = label;
    }

    public OpCode getOpCode() {
        return this.opCode;
    }

    public LabelNode getLabel() {
        return this.label;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        visitor.visitJumpInsn(this.opCode.getOpCode(), this.label.getLabel());
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitJumpInstruction(parent, this);
    }
}

