/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;

public abstract class BucketNodeMap {
    private final ToIntFunction<Split> splitToBucket;

    public BucketNodeMap(ToIntFunction<Split> splitToBucket) {
        this.splitToBucket = Objects.requireNonNull(splitToBucket, "splitToBucket is null");
    }

    public abstract int getBucketCount();

    public abstract Optional<InternalNode> getAssignedNode(int var1);

    public abstract void assignBucketToNode(int var1, InternalNode var2);

    public abstract boolean isDynamic();

    public final Optional<InternalNode> getAssignedNode(Split split) {
        return this.getAssignedNode(this.splitToBucket.applyAsInt(split));
    }
}

