/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.SignatureBuilder;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.TypeSignature;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Signature {
    private static final String OPERATOR_PREFIX = "$operator$";
    private final String name;
    private final List<TypeVariableConstraint> typeVariableConstraints;
    private final List<LongVariableConstraint> longVariableConstraints;
    private final TypeSignature returnType;
    private final List<TypeSignature> argumentTypes;
    private final boolean variableArity;

    @JsonCreator
    public Signature(@JsonProperty(value="name") String name, @JsonProperty(value="typeVariableConstraints") List<TypeVariableConstraint> typeVariableConstraints, @JsonProperty(value="longVariableConstraints") List<LongVariableConstraint> longVariableConstraints, @JsonProperty(value="returnType") TypeSignature returnType, @JsonProperty(value="argumentTypes") List<TypeSignature> argumentTypes, @JsonProperty(value="variableArity") boolean variableArity) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(typeVariableConstraints, "typeVariableConstraints is null");
        Objects.requireNonNull(longVariableConstraints, "longVariableConstraints is null");
        this.name = name;
        this.typeVariableConstraints = ImmutableList.copyOf(typeVariableConstraints);
        this.longVariableConstraints = ImmutableList.copyOf(longVariableConstraints);
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        this.variableArity = variableArity;
    }

    public Signature(String name, TypeSignature returnType, TypeSignature ... argumentTypes) {
        this(name, returnType, (List<TypeSignature>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public Signature(String name, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        this(name, (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), returnType, argumentTypes, false);
    }

    public static boolean isOperatorName(String mangledName) {
        return mangledName.startsWith(OPERATOR_PREFIX);
    }

    public static String mangleOperatorName(OperatorType operatorType) {
        return OPERATOR_PREFIX + operatorType.name();
    }

    @VisibleForTesting
    public static OperatorType unmangleOperator(String mangledName) {
        Preconditions.checkArgument((boolean)mangledName.startsWith(OPERATOR_PREFIX), (String)"not a mangled operator name: %s", (Object)mangledName);
        return OperatorType.valueOf((String)mangledName.substring(OPERATOR_PREFIX.length()).toUpperCase(Locale.ENGLISH));
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public TypeSignature getReturnType() {
        return this.returnType;
    }

    @JsonProperty
    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    @JsonProperty
    public boolean isVariableArity() {
        return this.variableArity;
    }

    @JsonProperty
    public List<TypeVariableConstraint> getTypeVariableConstraints() {
        return this.typeVariableConstraints;
    }

    @JsonProperty
    public List<LongVariableConstraint> getLongVariableConstraints() {
        return this.longVariableConstraints;
    }

    public int hashCode() {
        return Objects.hash(this.name.toLowerCase(Locale.US), this.typeVariableConstraints, this.longVariableConstraints, this.returnType, this.argumentTypes, this.variableArity);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Signature)) {
            return false;
        }
        Signature other = (Signature)obj;
        return this.name.equalsIgnoreCase(other.name) && Objects.equals(this.typeVariableConstraints, other.typeVariableConstraints) && Objects.equals(this.longVariableConstraints, other.longVariableConstraints) && Objects.equals(this.returnType, other.returnType) && Objects.equals(this.argumentTypes, other.argumentTypes) && Objects.equals(this.variableArity, other.variableArity);
    }

    public String toString() {
        List allConstraints = Stream.concat(this.typeVariableConstraints.stream().map(TypeVariableConstraint::toString), this.longVariableConstraints.stream().map(LongVariableConstraint::toString)).collect(Collectors.toList());
        return this.name + (String)(allConstraints.isEmpty() ? "" : "<" + Joiner.on((String)",").join(allConstraints) + ">") + "(" + Joiner.on((String)",").join(this.argumentTypes) + "):" + this.returnType;
    }

    public static TypeVariableConstraint withVariadicBound(String name, String variadicBound) {
        return new TypeVariableConstraint(name, false, false, variadicBound, (Set<TypeSignature>)ImmutableSet.of(), (Set<TypeSignature>)ImmutableSet.of());
    }

    public static TypeVariableConstraint comparableWithVariadicBound(String name, String variadicBound) {
        return new TypeVariableConstraint(name, true, false, variadicBound, (Set<TypeSignature>)ImmutableSet.of(), (Set<TypeSignature>)ImmutableSet.of());
    }

    public static TypeVariableConstraint typeVariable(String name) {
        return new TypeVariableConstraint(name, false, false, null, (Set<TypeSignature>)ImmutableSet.of(), (Set<TypeSignature>)ImmutableSet.of());
    }

    public static TypeVariableConstraint comparableTypeParameter(String name) {
        return new TypeVariableConstraint(name, true, false, null, (Set<TypeSignature>)ImmutableSet.of(), (Set<TypeSignature>)ImmutableSet.of());
    }

    public static TypeVariableConstraint orderableWithVariadicBound(String name, String variadicBound) {
        return new TypeVariableConstraint(name, false, true, variadicBound, (Set<TypeSignature>)ImmutableSet.of(), (Set<TypeSignature>)ImmutableSet.of());
    }

    public static TypeVariableConstraint orderableTypeParameter(String name) {
        return new TypeVariableConstraint(name, false, true, null, (Set<TypeSignature>)ImmutableSet.of(), (Set<TypeSignature>)ImmutableSet.of());
    }

    public static TypeVariableConstraint castableToTypeParameter(String name, TypeSignature ... toType) {
        return new TypeVariableConstraint(name, false, false, null, (Set<TypeSignature>)ImmutableSet.copyOf((Object[])toType), (Set<TypeSignature>)ImmutableSet.of());
    }

    public static TypeVariableConstraint castableToTypeParameter(String name, Set<TypeSignature> toType) {
        return new TypeVariableConstraint(name, false, false, null, toType, (Set<TypeSignature>)ImmutableSet.of());
    }

    public static TypeVariableConstraint castableFromTypeParameter(String name, TypeSignature ... toType) {
        return new TypeVariableConstraint(name, false, false, null, (Set<TypeSignature>)ImmutableSet.of(), (Set<TypeSignature>)ImmutableSet.copyOf((Object[])toType));
    }

    public static TypeVariableConstraint castableFromTypeParameter(String name, Set<TypeSignature> toType) {
        return new TypeVariableConstraint(name, false, false, null, (Set<TypeSignature>)ImmutableSet.of(), toType);
    }

    public static LongVariableConstraint longVariableExpression(String variable, String expression) {
        return new LongVariableConstraint(variable, expression);
    }

    public static SignatureBuilder builder() {
        return new SignatureBuilder();
    }
}

