/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimeZoneNotSupportedException;
import io.trino.type.DateTimes;
import io.trino.util.DateTimeZoneIndex;
import org.joda.time.DateTimeZone;

@ScalarFunction(value="with_timezone")
public class WithTimeZone {
    private WithTimeZone() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static long shortPrecision(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p)") long timestamp, @SqlType(value="varchar(x)") Slice zoneId) {
        TimeZoneKey toTimeZoneKey;
        Verify.verify((precision <= 3L ? 1 : 0) != 0, (String)"Expected precision <= 3", (Object[])new Object[0]);
        try {
            toTimeZoneKey = TimeZoneKey.getTimeZoneKey((String)zoneId.toStringUtf8());
        }
        catch (TimeZoneNotSupportedException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("'%s' is not a valid time zone", zoneId.toStringUtf8()));
        }
        DateTimeZone toDateTimeZone = DateTimeZoneIndex.getDateTimeZone(toTimeZoneKey);
        return DateTimeEncoding.packDateTimeWithZone((long)DateTimeZone.UTC.getMillisKeepLocal(toDateTimeZone, DateTimes.scaleEpochMicrosToMillis(timestamp)), (TimeZoneKey)toTimeZoneKey);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static LongTimestampWithTimeZone mediumPrecision(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p)") long timestamp, @SqlType(value="varchar(x)") Slice zoneId) {
        Verify.verify((precision > 3L && precision <= 6L ? 1 : 0) != 0, (String)"Expected precision in [4, 6]", (Object[])new Object[0]);
        return WithTimeZone.toLong(timestamp, 0, zoneId);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static LongTimestampWithTimeZone largePrecision(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p)") LongTimestamp timestamp, @SqlType(value="varchar(x)") Slice zoneId) {
        Verify.verify((precision > 6L ? 1 : 0) != 0, (String)"Expected precision > 6", (Object[])new Object[0]);
        return WithTimeZone.toLong(timestamp.getEpochMicros(), timestamp.getPicosOfMicro(), zoneId);
    }

    private static LongTimestampWithTimeZone toLong(long epochMicros, int picosOfMicro, Slice zoneId) {
        TimeZoneKey toTimeZoneKey;
        try {
            toTimeZoneKey = TimeZoneKey.getTimeZoneKey((String)zoneId.toStringUtf8());
        }
        catch (TimeZoneNotSupportedException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("'%s' is not a valid time zone", zoneId.toStringUtf8()));
        }
        DateTimeZone toDateTimeZone = DateTimeZoneIndex.getDateTimeZone(toTimeZoneKey);
        long epochMillis = DateTimes.scaleEpochMicrosToMillis(epochMicros);
        epochMillis = DateTimeZone.UTC.getMillisKeepLocal(toDateTimeZone, epochMillis);
        int picosOfMilli = DateTimes.getMicrosOfMilli(epochMicros) * 1000000 + picosOfMicro;
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)epochMillis, (int)picosOfMilli, (TimeZoneKey)toTimeZoneKey);
    }
}

