/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class PatternQuantifier
extends Node {
    private final boolean greedy;

    protected PatternQuantifier(Optional<NodeLocation> location, boolean greedy) {
        super(location);
        this.greedy = greedy;
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPatternQuantifier(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PatternQuantifier o = (PatternQuantifier)obj;
        return this.greedy == o.greedy;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.greedy);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!PatternQuantifier.sameClass(this, other)) {
            return false;
        }
        PatternQuantifier otherNode = (PatternQuantifier)other;
        return this.greedy == otherNode.greedy;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("greedy", this.greedy).toString();
    }
}

