/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_10.transport.Header;
import org.apache.qpid.server.protocol.v0_10.transport.MethodDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolEvent;
import org.apache.qpid.server.protocol.v0_10.transport.Struct;
import org.apache.qpid.server.protocol.v0_10.transport.StructFactory;
import org.apache.qpid.server.transport.util.Functions;

public abstract class Method
extends Struct
implements ProtocolEvent {
    private int id;
    private int channel;
    private boolean idSet = false;
    private boolean sync = false;
    private boolean batch = false;
    private boolean unreliable = false;
    private CompletionListener completionListener;

    public static final Method create(int type) {
        return (Method)StructFactory.createInstruction(type);
    }

    public final int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.idSet = true;
    }

    boolean idSet() {
        return this.idSet;
    }

    @Override
    public final int getChannel() {
        return this.channel;
    }

    @Override
    public final void setChannel(int channel) {
        this.channel = channel;
    }

    public final boolean isSync() {
        return this.sync;
    }

    public final void setSync(boolean value) {
        this.sync = value;
    }

    public final boolean isBatch() {
        return this.batch;
    }

    final void setBatch(boolean value) {
        this.batch = value;
    }

    public final boolean isUnreliable() {
        return this.unreliable;
    }

    final void setUnreliable(boolean value) {
        this.unreliable = value;
    }

    public abstract boolean hasPayload();

    public Header getHeader() {
        return null;
    }

    public void setHeader(Header header) {
        throw new UnsupportedOperationException();
    }

    public QpidByteBuffer getBody() {
        return null;
    }

    public void setBody(QpidByteBuffer body) {
        throw new UnsupportedOperationException();
    }

    public int getBodySize() {
        return 0;
    }

    @Override
    public abstract byte getEncodedTrack();

    public abstract <C> void dispatch(C var1, MethodDelegate<C> var2);

    @Override
    public <C> void delegate(C context, ProtocolDelegate<C> delegate) {
        if (this.getEncodedTrack() == 3) {
            delegate.command(context, this);
        } else {
            delegate.control(context, this);
        }
    }

    public void setCompletionListener(CompletionListener completionListener) {
        this.completionListener = completionListener;
    }

    public void complete() {
        if (this.completionListener != null) {
            this.completionListener.onComplete(this);
            this.completionListener = null;
        }
    }

    public boolean hasCompletionListener() {
        return this.completionListener != null;
    }

    @Override
    public final int getEncodedLength() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        QpidByteBuffer body;
        StringBuilder str = new StringBuilder();
        str.append("ch=");
        str.append(this.channel);
        if (this.getEncodedTrack() == 3 && this.idSet) {
            str.append(" id=");
            str.append(this.id);
        }
        if (this.sync || this.batch) {
            str.append(" ");
            str.append("[");
            if (this.sync) {
                str.append("S");
            }
            if (this.batch) {
                str.append("B");
            }
            str.append("]");
        }
        str.append(" ");
        str.append(super.toString());
        Header hdr = this.getHeader();
        if (hdr != null) {
            for (Struct st : hdr.getStructs()) {
                str.append("\n  ");
                str.append(st);
            }
        }
        if ((body = this.getBody()) != null) {
            str.append("\n  body=");
            str.append(Functions.str((QpidByteBuffer)body, (int)64));
        }
        return str.toString();
    }

    public static interface CompletionListener {
        public void onComplete(Method var1);
    }
}

