/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdArraySerializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;

class MessageContentJsonConverter {
    private static final int BRACKETS_COUNT = 2;
    private static final int NULL_LENGTH = 4;
    private static final String DOTS = "...";
    private final ObjectMapper _objectMapper;
    private final Object _messageBody;
    private long _remaining;

    MessageContentJsonConverter(Object messageBody, long limit) {
        this._messageBody = messageBody;
        this._objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new NoneBase64ByteArraySerializer());
        this._objectMapper.registerModule((Module)module);
        this._remaining = limit;
    }

    public void convertAndWrite(OutputStream outputStream) throws IOException {
        Object messageBody = this._messageBody;
        if (this._remaining >= 0L) {
            messageBody = this.convertAndTruncate(this._messageBody);
        }
        this._objectMapper.writeValue(outputStream, messageBody);
    }

    private Object convertAndTruncate(Object source) throws IOException {
        if (source == null) {
            this._remaining -= 4L;
            return null;
        }
        if (source instanceof String || source instanceof Character) {
            return this.copyString(String.valueOf(source));
        }
        if (source instanceof Number || source instanceof Boolean || source.getClass().isPrimitive()) {
            this._remaining -= (long)this._objectMapper.writeValueAsString(source).length();
            return source;
        }
        if (source instanceof Map) {
            return this.copyMap((Map)source);
        }
        if (source instanceof Collection) {
            return this.copyCollection((Collection)source);
        }
        if (source instanceof UUID) {
            return this.copyString(source.toString());
        }
        if (source.getClass().isArray()) {
            return this.copyArray(source);
        }
        return this.copyString(String.valueOf(source));
    }

    private Object copyString(String source) throws IOException {
        String value = this._objectMapper.writeValueAsString((Object)source);
        if (this._remaining >= (long)value.length()) {
            this._remaining -= (long)value.length();
            return source;
        }
        if (this._remaining > 0L) {
            int limit = Math.min((int)this._remaining, source.length());
            String truncated = source.substring(0, limit) + DOTS;
            this._remaining -= (long)truncated.length();
            return truncated;
        }
        return DOTS;
    }

    private Object copyCollection(Collection source) throws IOException {
        this._remaining -= 2L;
        LinkedList<Object> copy = new LinkedList<Object>();
        for (Object item : source) {
            if (this._remaining <= 0L) break;
            Object copiedItem = this.convertAndTruncate(item);
            copy.add(copiedItem);
            if (copy.size() <= 0) continue;
            --this._remaining;
        }
        return copy;
    }

    private Object copyMap(Map source) throws IOException {
        this._remaining -= 2L;
        LinkedHashMap<Object, Object> copy = new LinkedHashMap<Object, Object>();
        for (Object key : source.keySet()) {
            if (this._remaining <= 0L) break;
            Object copiedKey = this.convertAndTruncate(key);
            Object copiedValue = this.convertAndTruncate(source.get(key));
            copy.put(copiedKey, copiedValue);
            --this._remaining;
            if (copy.size() <= 0) continue;
            --this._remaining;
        }
        return copy;
    }

    private Object copyArray(Object source) throws IOException {
        LinkedList<Object> copy = new LinkedList<Object>();
        int length = Array.getLength(source);
        for (int i = 0; i < length; ++i) {
            copy.add(Array.get(source, i));
        }
        return this.copyCollection(copy);
    }

    private static class NoneBase64ByteArraySerializer
    extends StdSerializer<byte[]> {
        final StdArraySerializers.IntArraySerializer _underlying = new StdArraySerializers.IntArraySerializer();

        public NoneBase64ByteArraySerializer() {
            super(byte[].class);
        }

        public void serialize(byte[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            int[] intArray = new int[value.length];
            for (int i = 0; i < value.length; ++i) {
                intArray[i] = value[i];
            }
            this._underlying.serialize(intArray, jgen, provider);
        }
    }
}

