/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.jcr.resource.internal.helper.CalendarConverter;
import org.apache.sling.jcr.resource.internal.helper.Converter;
import org.apache.sling.jcr.resource.internal.helper.NumberConverter;
import org.jetbrains.annotations.NotNull;

public class DateConverter
extends NumberConverter
implements Converter {
    private final Date value;

    public DateConverter(Date val) {
        super(val.getTime());
        this.value = val;
    }

    @Override
    @NotNull
    public ZonedDateTime toZonedDateTime() {
        return new CalendarConverter(this.toCalendar()).toZonedDateTime();
    }

    @Override
    @NotNull
    public Calendar toCalendar() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(this.toLong());
        return c;
    }

    @Override
    @NotNull
    public Date toDate() {
        return this.value;
    }

    @Override
    public String toString() {
        return ISO8601.format(this.toCalendar());
    }
}

