/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.principal;

import java.security.Principal;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalQueryManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrincipalManagerImpl
implements PrincipalQueryManager,
PrincipalManager {
    private final PrincipalProvider principalProvider;

    public PrincipalManagerImpl(@NotNull PrincipalProvider principalProvider) {
        this.principalProvider = principalProvider;
    }

    @Override
    public boolean hasPrincipal(@NotNull String principalName) {
        return this.principalProvider.getPrincipal(principalName) != null;
    }

    @Override
    @Nullable
    public Principal getPrincipal(@NotNull String principalName) {
        return this.principalProvider.getPrincipal(principalName);
    }

    @Override
    @NotNull
    public PrincipalIterator findPrincipals(@Nullable String simpleFilter) {
        return this.findPrincipals(simpleFilter, 3);
    }

    @Override
    @NotNull
    public PrincipalIterator findPrincipals(@Nullable String simpleFilter, int searchType) {
        return new PrincipalIteratorAdapter(this.principalProvider.findPrincipals(simpleFilter, searchType));
    }

    @Override
    @NotNull
    public PrincipalIterator getPrincipals(int searchType) {
        return new PrincipalIteratorAdapter(this.principalProvider.findPrincipals(searchType));
    }

    @Override
    @NotNull
    public PrincipalIterator getGroupMembership(@NotNull Principal principal) {
        return new PrincipalIteratorAdapter(this.principalProvider.getMembershipPrincipals(principal));
    }

    @Override
    @NotNull
    public Principal getEveryone() {
        Principal everyone = this.getPrincipal("everyone");
        if (everyone == null) {
            everyone = EveryonePrincipal.getInstance();
        }
        return everyone;
    }

    @Override
    @NotNull
    public PrincipalIterator findPrincipals(@Nullable String simpleFilter, boolean fullText, int searchType, long offset, long limit) {
        return new PrincipalIteratorAdapter(this.principalProvider.findPrincipals(simpleFilter, fullText, searchType, offset, limit));
    }
}

