/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.stats;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.storm.daemon.Task;
import org.apache.storm.generated.BoltStats;
import org.apache.storm.generated.ExecutorSpecificStats;
import org.apache.storm.generated.ExecutorStats;
import org.apache.storm.metric.internal.MultiCountStat;
import org.apache.storm.metric.internal.MultiLatencyStat;
import org.apache.storm.shade.com.google.common.collect.Lists;
import org.apache.storm.stats.ClientStatsUtil;
import org.apache.storm.stats.CommonStats;

public class BoltExecutorStats
extends CommonStats {
    MultiCountStat executedStats;
    MultiLatencyStat processLatencyStats;
    MultiLatencyStat executeLatencyStats;

    public BoltExecutorStats(int rate, int numStatBuckets) {
        super(rate, numStatBuckets);
        this.executedStats = new MultiCountStat(numStatBuckets);
        this.processLatencyStats = new MultiLatencyStat(numStatBuckets);
        this.executeLatencyStats = new MultiLatencyStat(numStatBuckets);
    }

    public MultiCountStat getExecuted() {
        return this.executedStats;
    }

    public MultiLatencyStat getProcessLatencies() {
        return this.processLatencyStats;
    }

    public MultiLatencyStat getExecuteLatencies() {
        return this.executeLatencyStats;
    }

    @Override
    public void cleanupStats() {
        this.executedStats.close();
        this.processLatencyStats.close();
        this.executeLatencyStats.close();
        super.cleanupStats();
    }

    public void boltExecuteTuple(String component, String stream, long latencyMs, long workerUptimeSecs, Task firstExecutorTask) {
        ArrayList key = Lists.newArrayList((Object[])new String[]{component, stream});
        this.getExecuted().incBy(key, this.rate);
        this.getExecuteLatencies().record(key, latencyMs);
        double capacity = this.calculateCapacity(workerUptimeSecs);
        firstExecutorTask.getTaskMetrics().setCapacity(capacity);
    }

    private double calculateCapacity(long workerUptimeSecs) {
        if (workerUptimeSecs > 0L) {
            Map<String, Double> execAvg = this.valueStat(this.getExecuteLatencies()).get("600");
            Map<String, Long> exec = this.valueStat(this.getExecuted()).get("600");
            HashSet<String> allKeys = new HashSet<String>();
            if (execAvg != null) {
                allKeys.addAll(execAvg.keySet());
            }
            if (exec != null) {
                allKeys.addAll(exec.keySet());
            }
            double totalAvg = 0.0;
            for (Object e : allKeys) {
                double avg = BoltExecutorStats.getOr0(execAvg, e).doubleValue();
                long cnt = BoltExecutorStats.getOr0(exec, e).longValue();
                totalAvg += avg * (double)cnt;
            }
            return totalAvg / (double)(Math.min(workerUptimeSecs, 600L) * 1000L);
        }
        return 0.0;
    }

    private static Number getOr0(Map m, Object k) {
        if (m == null) {
            return 0;
        }
        Number n = (Number)m.get(k);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public void boltAckedTuple(String component, String stream, long latencyMs) {
        ArrayList key = Lists.newArrayList((Object[])new String[]{component, stream});
        this.getAcked().incBy(key, this.rate);
        this.getProcessLatencies().record(key, latencyMs);
    }

    public void boltFailedTuple(String component, String stream) {
        ArrayList key = Lists.newArrayList((Object[])new String[]{component, stream});
        this.getFailed().incBy(key, this.rate);
    }

    @Override
    public ExecutorStats renderStats() {
        ExecutorStats ret = new ExecutorStats();
        ret.set_emitted(this.valueStat(this.getEmitted()));
        ret.set_transferred(this.valueStat(this.getTransferred()));
        ret.set_rate(this.rate);
        BoltStats boltStats = new BoltStats(ClientStatsUtil.windowSetConverter(this.valueStat(this.getAcked()), ClientStatsUtil.TO_GSID, ClientStatsUtil.IDENTITY), ClientStatsUtil.windowSetConverter(this.valueStat(this.getFailed()), ClientStatsUtil.TO_GSID, ClientStatsUtil.IDENTITY), ClientStatsUtil.windowSetConverter(this.valueStat(this.processLatencyStats), ClientStatsUtil.TO_GSID, ClientStatsUtil.IDENTITY), ClientStatsUtil.windowSetConverter(this.valueStat(this.executedStats), ClientStatsUtil.TO_GSID, ClientStatsUtil.IDENTITY), ClientStatsUtil.windowSetConverter(this.valueStat(this.executeLatencyStats), ClientStatsUtil.TO_GSID, ClientStatsUtil.IDENTITY));
        ret.set_specific(ExecutorSpecificStats.bolt(boltStats));
        return ret;
    }
}

