/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.fluent;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.storm.trident.Stream;
import org.apache.storm.trident.fluent.ChainedFullAggregatorDeclarer;
import org.apache.storm.trident.fluent.ChainedPartitionAggregatorDeclarer;
import org.apache.storm.trident.fluent.GlobalAggregationScheme;
import org.apache.storm.trident.fluent.IAggregatableStream;
import org.apache.storm.trident.operation.Aggregator;
import org.apache.storm.trident.operation.CombinerAggregator;
import org.apache.storm.trident.operation.ReducerAggregator;
import org.apache.storm.trident.operation.impl.ChainedAggregatorImpl;
import org.apache.storm.trident.operation.impl.ChainedResult;
import org.apache.storm.trident.operation.impl.CombinerAggregatorCombineImpl;
import org.apache.storm.trident.operation.impl.CombinerAggregatorInitImpl;
import org.apache.storm.trident.operation.impl.ReducerAggregatorImpl;
import org.apache.storm.trident.operation.impl.SingleEmitAggregator;
import org.apache.storm.trident.tuple.ComboList;
import org.apache.storm.tuple.Fields;

public class ChainedAggregatorDeclarer
implements ChainedFullAggregatorDeclarer,
ChainedPartitionAggregatorDeclarer {
    List<AggSpec> aggs = new ArrayList<AggSpec>();
    IAggregatableStream stream;
    AggType type = null;
    GlobalAggregationScheme globalScheme;

    public ChainedAggregatorDeclarer(IAggregatableStream stream, GlobalAggregationScheme globalScheme) {
        this.stream = stream;
        this.globalScheme = globalScheme;
    }

    @Override
    public Stream chainEnd() {
        Fields[] inputFields = new Fields[this.aggs.size()];
        Aggregator[] aggs = new Aggregator[this.aggs.size()];
        int[] outSizes = new int[this.aggs.size()];
        ArrayList<String> allOutFields = new ArrayList<String>();
        HashSet<String> allInFields = new HashSet<String>();
        for (int i = 0; i < this.aggs.size(); ++i) {
            Fields outfields;
            AggSpec spec = this.aggs.get(i);
            Fields infields = spec.inFields;
            if (infields == null) {
                infields = new Fields(new String[0]);
            }
            if ((outfields = spec.outFields) == null) {
                outfields = new Fields(new String[0]);
            }
            inputFields[i] = infields;
            aggs[i] = spec.agg;
            outSizes[i] = outfields.size();
            allOutFields.addAll(outfields.toList());
            allInFields.addAll(infields.toList());
        }
        if (new HashSet(allOutFields).size() != allOutFields.size()) {
            throw new IllegalArgumentException("Output fields for chained aggregators must be distinct: " + ((Object)allOutFields).toString());
        }
        Fields inFields = new Fields(new ArrayList<String>(allInFields));
        Fields outFields = new Fields(allOutFields);
        ChainedAggregatorImpl combined = new ChainedAggregatorImpl(aggs, inputFields, new ComboList.Factory(outSizes));
        if (this.type != AggType.FULL) {
            this.stream = this.stream.partitionAggregate(inFields, combined, outFields);
        }
        if (this.type != AggType.PARTITION) {
            this.stream = this.globalScheme.aggPartition(this.stream);
            SingleEmitAggregator.BatchToPartition singleEmit = this.globalScheme.singleEmitPartitioner();
            Aggregator<ChainedResult> toAgg = combined;
            if (singleEmit != null) {
                toAgg = new SingleEmitAggregator(combined, singleEmit);
            }
            this.stream = this.stream.partitionAggregate(inFields, toAgg, outFields);
        }
        return this.stream.toStream();
    }

    @Override
    public ChainedPartitionAggregatorDeclarer partitionAggregate(Aggregator agg, Fields functionFields) {
        return this.partitionAggregate(null, agg, functionFields);
    }

    @Override
    public ChainedPartitionAggregatorDeclarer partitionAggregate(Fields inputFields, Aggregator agg, Fields functionFields) {
        this.type = AggType.PARTITION;
        this.aggs.add(new AggSpec(inputFields, agg, functionFields));
        return this;
    }

    @Override
    public ChainedPartitionAggregatorDeclarer partitionAggregate(CombinerAggregator agg, Fields functionFields) {
        return this.partitionAggregate(null, agg, functionFields);
    }

    @Override
    public ChainedPartitionAggregatorDeclarer partitionAggregate(Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        this.initCombiner(inputFields, agg, functionFields);
        return this.partitionAggregate(functionFields, new CombinerAggregatorCombineImpl(agg), functionFields);
    }

    @Override
    public ChainedPartitionAggregatorDeclarer partitionAggregate(ReducerAggregator agg, Fields functionFields) {
        return this.partitionAggregate(null, agg, functionFields);
    }

    @Override
    public ChainedPartitionAggregatorDeclarer partitionAggregate(Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        return this.partitionAggregate(inputFields, new ReducerAggregatorImpl(agg), functionFields);
    }

    @Override
    public ChainedFullAggregatorDeclarer aggregate(Aggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    @Override
    public ChainedFullAggregatorDeclarer aggregate(Fields inputFields, Aggregator agg, Fields functionFields) {
        return this.aggregate(inputFields, agg, functionFields, false);
    }

    private ChainedFullAggregatorDeclarer aggregate(Fields inputFields, Aggregator agg, Fields functionFields, boolean isCombiner) {
        if (isCombiner) {
            if (this.type == null) {
                this.type = AggType.FULL_COMBINE;
            }
        } else {
            this.type = AggType.FULL;
        }
        this.aggs.add(new AggSpec(inputFields, agg, functionFields));
        return this;
    }

    @Override
    public ChainedFullAggregatorDeclarer aggregate(CombinerAggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    @Override
    public ChainedFullAggregatorDeclarer aggregate(Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        this.initCombiner(inputFields, agg, functionFields);
        return this.aggregate(functionFields, new CombinerAggregatorCombineImpl(agg), functionFields, true);
    }

    @Override
    public ChainedFullAggregatorDeclarer aggregate(ReducerAggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    @Override
    public ChainedFullAggregatorDeclarer aggregate(Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        return this.aggregate(inputFields, new ReducerAggregatorImpl(agg), functionFields);
    }

    private void initCombiner(Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        this.stream = this.stream.each(inputFields, new CombinerAggregatorInitImpl(agg), functionFields);
    }

    private static enum AggType {
        PARTITION,
        FULL,
        FULL_COMBINE;

    }

    private static class AggSpec {
        Fields inFields;
        Aggregator agg;
        Fields outFields;

        AggSpec(Fields inFields, Aggregator agg, Fields outFields) {
            this.inFields = inFields;
            this.agg = agg;
            this.outFields = outFields;
        }
    }

    public static interface AggregationPartition {
        public Stream partition(Stream var1);
    }
}

