/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.thrift.transport;

import org.apache.storm.thrift.TConfiguration;
import org.apache.storm.thrift.transport.TEndpointTransport;
import org.apache.storm.thrift.transport.TTransportException;

public final class TMemoryInputTransport
extends TEndpointTransport {
    private byte[] buf_;
    private int pos_;
    private int endPos_;

    public TMemoryInputTransport() throws TTransportException {
        this(new TConfiguration());
    }

    public TMemoryInputTransport(TConfiguration _configuration) throws TTransportException {
        this(_configuration, new byte[0]);
    }

    public TMemoryInputTransport(byte[] buf) throws TTransportException {
        this(new TConfiguration(), buf);
    }

    public TMemoryInputTransport(TConfiguration _configuration, byte[] buf) throws TTransportException {
        this(_configuration, buf, 0, buf.length);
    }

    public TMemoryInputTransport(byte[] buf, int offset, int length) throws TTransportException {
        this(new TConfiguration(), buf, offset, length);
    }

    public TMemoryInputTransport(TConfiguration _configuration, byte[] buf, int offset, int length) throws TTransportException {
        super(_configuration);
        this.reset(buf, offset, length);
        this.updateKnownMessageSize(length);
    }

    public void reset(byte[] buf) {
        this.reset(buf, 0, buf.length);
    }

    public void reset(byte[] buf, int offset, int length) {
        this.buf_ = buf;
        this.pos_ = offset;
        this.endPos_ = offset + length;
        try {
            this.resetConsumedMessageSize(-1L);
        }
        catch (TTransportException tTransportException) {
            // empty catch block
        }
    }

    public void clear() {
        this.buf_ = null;
        try {
            this.resetConsumedMessageSize(-1L);
        }
        catch (TTransportException tTransportException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() throws TTransportException {
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        int amtToRead;
        int bytesRemaining = this.getBytesRemainingInBuffer();
        int n = amtToRead = len > bytesRemaining ? bytesRemaining : len;
        if (amtToRead > 0) {
            System.arraycopy(this.buf_, this.pos_, buf, off, amtToRead);
            this.consumeBuffer(amtToRead);
            this.countConsumedMessageBytes(amtToRead);
        }
        return amtToRead;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws TTransportException {
        throw new UnsupportedOperationException("No writing allowed!");
    }

    @Override
    public byte[] getBuffer() {
        return this.buf_;
    }

    @Override
    public int getBufferPosition() {
        return this.pos_;
    }

    @Override
    public int getBytesRemainingInBuffer() {
        return this.endPos_ - this.pos_;
    }

    @Override
    public void consumeBuffer(int len) {
        this.pos_ += len;
    }
}

