/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.generated.WorkerResources;

public class EquivalenceUtils {
    public static boolean areLocalAssignmentsEquivalent(LocalAssignment first, LocalAssignment second) {
        HashSet bexec;
        HashSet aexec;
        if (first == null && second == null) {
            return true;
        }
        if (first != null && second != null && first.get_topology_id().equals(second.get_topology_id()) && (aexec = new HashSet(first.get_executors())).equals(bexec = new HashSet(second.get_executors()))) {
            boolean firstHasResources = first.is_set_resources();
            boolean secondHasResources = second.is_set_resources();
            if (!firstHasResources && !secondHasResources) {
                return true;
            }
            if (firstHasResources && secondHasResources) {
                WorkerResources firstResources = first.get_resources();
                WorkerResources secondResources = second.get_resources();
                return EquivalenceUtils.customWorkerResourcesEquality(firstResources, secondResources);
            }
        }
        return false;
    }

    @VisibleForTesting
    static boolean customWorkerResourcesEquality(WorkerResources first, WorkerResources second) {
        if (first == null) {
            return false;
        }
        if (second == null) {
            return false;
        }
        if (first == second) {
            return true;
        }
        if (first.equals(second)) {
            return true;
        }
        if (first.get_cpu() != second.get_cpu()) {
            return false;
        }
        if (first.get_mem_on_heap() != second.get_mem_on_heap()) {
            return false;
        }
        if (first.get_mem_off_heap() != second.get_mem_off_heap()) {
            return false;
        }
        if (first.get_shared_mem_off_heap() != second.get_shared_mem_off_heap()) {
            return false;
        }
        if (first.get_shared_mem_on_heap() != second.get_shared_mem_on_heap()) {
            return false;
        }
        if (!EquivalenceUtils.customResourceMapEquality(first.get_resources(), second.get_resources())) {
            return false;
        }
        return EquivalenceUtils.customResourceMapEquality(first.get_shared_resources(), second.get_shared_resources());
    }

    private static boolean customResourceMapEquality(Map<String, Double> firstMap, Map<String, Double> secondMap) {
        if (firstMap == null && secondMap == null) {
            return true;
        }
        if (firstMap == null) {
            firstMap = new HashMap<String, Double>();
        }
        if (secondMap == null) {
            secondMap = new HashMap<String, Double>();
        }
        HashSet<String> keys = new HashSet<String>(firstMap.keySet());
        keys.addAll(secondMap.keySet());
        for (String key : keys) {
            if (firstMap.getOrDefault(key, 0.0).doubleValue() == secondMap.getOrDefault(key, 0.0).doubleValue()) continue;
            return false;
        }
        return true;
    }
}

