/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.base;

import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.com.google.common.collect.PrimitiveArrays;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Message {
    private static final Map<String, Message> messageCache = Maps.newHashMap();
    private final String msg;
    private final int[] paramLocations;
    private static final Pattern PARAM_PATTERN = Pattern.compile("%[1-9%]");

    public static Message getInstance(String msg) {
        if (!messageCache.containsKey(msg)) {
            messageCache.put(msg, new Message(msg));
        }
        return messageCache.get(msg);
    }

    private Message(String msg) {
        this.msg = msg;
        this.paramLocations = Message.calculateParamLocations(msg);
    }

    private static int[] calculateParamLocations(String msg) {
        ArrayList<Integer> locs = Lists.newArrayList();
        Matcher m = PARAM_PATTERN.matcher(msg);
        int start = 0;
        while (m.find(start)) {
            locs.add(m.start());
            start = m.end();
        }
        return PrimitiveArrays.toIntArray(locs);
    }

    public String toString(String ... parameters) {
        if (this.paramLocations.length == 0) {
            return this.msg;
        }
        StringBuilder sb = new StringBuilder();
        int cur = 0;
        for (int pos : this.paramLocations) {
            sb.append(this.msg, cur, pos);
            char ch = this.msg.charAt(pos + 1);
            if (ch == '%') {
                sb.append('%');
            } else {
                int i = ch - 49;
                if (i >= parameters.length) {
                    throw new IllegalArgumentException("Parameter %" + ch + " not supplied for translation \"" + this.msg + "\"");
                }
                sb.append(parameters[i]);
            }
            cur = pos + 2;
        }
        sb.append(this.msg, cur, this.msg.length());
        return sb.toString();
    }
}

