/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.rapier;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.uima.ruta.textruler.learner.rapier.RapierRule;

public class RapierRulePriorityQueue
implements Iterable<RapierRule> {
    private PriorityQueue<RapierRule> ruleList;
    private PriorityQueue<RapierRule> reverseRuleList;
    private int maxSize;

    public RapierRulePriorityQueue(int maxSize) {
        this.maxSize = maxSize;
        this.ruleList = new PriorityQueue<RapierRule>(maxSize, new Comparator<RapierRule>(){

            @Override
            public int compare(RapierRule o1, RapierRule o2) {
                if (o1.getPriority() > o2.getPriority()) {
                    return 1;
                }
                if (o1.getPriority() < o2.getPriority()) {
                    return -1;
                }
                return 0;
            }
        });
        this.reverseRuleList = new PriorityQueue<RapierRule>(maxSize, new Comparator<RapierRule>(){

            @Override
            public int compare(RapierRule o1, RapierRule o2) {
                if (o1.getPriority() < o2.getPriority()) {
                    return 1;
                }
                if (o1.getPriority() > o2.getPriority()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    @Override
    public Iterator<RapierRule> iterator() {
        return this.ruleList.iterator();
    }

    public void clear() {
        this.ruleList.clear();
        this.reverseRuleList.clear();
    }

    public void addAll(Collection<RapierRule> rules) {
        for (RapierRule r : rules) {
            this.add(r);
        }
    }

    public void add(RapierRule rule) {
        this.ruleList.add(rule);
        this.reverseRuleList.add(rule);
        while (this.ruleList.size() > this.maxSize) {
            RapierRule tail = this.reverseRuleList.peek();
            this.ruleList.remove(tail);
            this.reverseRuleList.remove(tail);
        }
    }

    public RapierRule peek() {
        return this.ruleList.peek();
    }
}

