/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSDictionaryMap;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;

public class PDDeviceNAttributes {
    private COSDictionary dictionary;

    public PDDeviceNAttributes() {
        this.dictionary = new COSDictionary();
    }

    public PDDeviceNAttributes(COSDictionary attributes) {
        this.dictionary = attributes;
    }

    public COSDictionary getCOSDictionary() {
        return this.dictionary;
    }

    public Map getColorants() throws IOException {
        HashMap<String, PDColorSpace> actuals = new HashMap<String, PDColorSpace>();
        COSDictionary colorants = (COSDictionary)this.dictionary.getDictionaryObject(COSName.COLORANTS);
        if (colorants == null) {
            colorants = new COSDictionary();
            this.dictionary.setItem(COSName.COLORANTS, (COSBase)colorants);
        }
        for (COSName name : colorants.keySet()) {
            COSBase value = colorants.getDictionaryObject(name);
            actuals.put(name.getName(), PDColorSpaceFactory.createColorSpace(value));
        }
        return new COSDictionaryMap(actuals, colorants);
    }

    public void setColorants(Map colorants) {
        COSDictionary colorantDict = null;
        if (colorants != null) {
            colorantDict = COSDictionaryMap.convert(colorants);
        }
        this.dictionary.setItem(COSName.COLORANTS, (COSBase)colorantDict);
    }
}

