/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import org.apache.pdfbox.pdmodel.common.PDMatrix;
import org.apache.pdfbox.pdmodel.graphics.color.PDGamma;
import org.apache.pdfbox.pdmodel.graphics.color.PDTristimulus;

public class ColorSpaceCalRGB
extends ColorSpace {
    private PDGamma gamma = null;
    private PDTristimulus whitepoint = null;
    private PDTristimulus blackpoint = null;
    private PDMatrix matrix = null;
    private static final long serialVersionUID = -6362864473145799405L;

    public ColorSpaceCalRGB() {
        super(13, 3);
    }

    public ColorSpaceCalRGB(PDGamma gammaValue, PDTristimulus whitept, PDTristimulus blackpt, PDMatrix linearMatrix) {
        this();
        this.gamma = gammaValue;
        this.whitepoint = whitept;
        this.blackpoint = blackpt;
        this.matrix = linearMatrix;
    }

    private float[] fromRGBtoCIEXYZ(float[] rgbvalue) {
        ColorSpace colorspaceRGB = ColorSpace.getInstance(1000);
        return colorspaceRGB.toCIEXYZ(rgbvalue);
    }

    private float[] fromCIEXYZtoRGB(float[] xyzvalue) {
        ColorSpace colorspaceXYZ = ColorSpace.getInstance(1001);
        return colorspaceXYZ.toRGB(xyzvalue);
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        if (colorvalue != null && colorvalue.length == 3) {
            return this.fromCIEXYZtoRGB(colorvalue);
        }
        return null;
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        if (rgbvalue != null && rgbvalue.length == 3) {
            return rgbvalue;
        }
        return null;
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        if (colorvalue != null && colorvalue.length == 4) {
            return this.fromRGBtoCIEXYZ(this.toRGB(colorvalue));
        }
        return null;
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        if (colorvalue != null && colorvalue.length == 3) {
            return colorvalue;
        }
        return null;
    }
}

