/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType3;
import org.apache.pdfbox.pdmodel.graphics.shading.ShadingContext;
import org.apache.pdfbox.util.Matrix;

public class RadialShadingContext
extends ShadingContext
implements PaintContext {
    private static final Log LOG = LogFactory.getLog(RadialShadingContext.class);
    private PDShadingType3 radialShadingType;
    private final float[] coords;
    private final float[] domain;
    private float[] background;
    private int rgbBackground;
    private final boolean[] extend;
    private final double x1x0;
    private final double y1y0;
    private final double r1r0;
    private final double x1x0pow2;
    private final double y1y0pow2;
    private final double r0pow2;
    private final float d1d0;
    private final double denom;
    private final double longestDistance;
    private final int[] colorTable;

    public RadialShadingContext(PDShadingType3 shading, ColorModel colorModel, AffineTransform xform, Matrix ctm, int pageHeight, Rectangle dBounds) throws IOException {
        super(shading, colorModel, xform, ctm, pageHeight, dBounds);
        this.radialShadingType = shading;
        this.coords = shading.getCoords().toFloatArray();
        if (ctm != null) {
            ctm.createAffineTransform().transform(this.coords, 0, this.coords, 0, 1);
            ctm.createAffineTransform().transform(this.coords, 3, this.coords, 3, 1);
            this.coords[2] = this.coords[2] * ctm.getXScale();
            this.coords[5] = this.coords[5] * ctm.getXScale();
            this.coords[1] = (float)pageHeight - this.coords[1];
            this.coords[4] = (float)pageHeight - this.coords[4];
        } else {
            float translateY = (float)xform.getTranslateY();
            this.coords[1] = (float)pageHeight + translateY - this.coords[1];
            this.coords[4] = (float)pageHeight + translateY - this.coords[4];
        }
        xform.transform(this.coords, 0, this.coords, 0, 1);
        xform.transform(this.coords, 3, this.coords, 3, 1);
        this.coords[2] = (float)((double)this.coords[2] * xform.getScaleX());
        this.coords[5] = (float)((double)this.coords[5] * xform.getScaleX());
        this.coords[2] = Math.abs(this.coords[2]);
        this.coords[5] = Math.abs(this.coords[5]);
        this.domain = this.radialShadingType.getDomain() != null ? shading.getDomain().toFloatArray() : new float[]{0.0f, 1.0f};
        COSArray extendValues = shading.getExtend();
        if (extendValues != null) {
            this.extend = new boolean[2];
            this.extend[0] = ((COSBoolean)extendValues.getObject(0)).getValue();
            this.extend[1] = ((COSBoolean)extendValues.getObject(1)).getValue();
        } else {
            this.extend = new boolean[]{false, false};
        }
        this.x1x0 = this.coords[3] - this.coords[0];
        this.y1y0 = this.coords[4] - this.coords[1];
        this.r1r0 = this.coords[5] - this.coords[2];
        this.x1x0pow2 = Math.pow(this.x1x0, 2.0);
        this.y1y0pow2 = Math.pow(this.y1y0, 2.0);
        this.r0pow2 = Math.pow(this.coords[2], 2.0);
        this.denom = this.x1x0pow2 + this.y1y0pow2 - Math.pow(this.r1r0, 2.0);
        this.d1d0 = this.domain[1] - this.domain[0];
        COSArray bg = shading.getBackground();
        if (bg != null) {
            this.background = bg.toFloatArray();
            this.rgbBackground = this.convertToRGB(this.background);
        }
        this.longestDistance = this.getLongestDis();
        this.colorTable = this.calcColorTable();
    }

    private double getLongestDis() {
        double rmax;
        double rmin;
        double centerToCenter = Math.sqrt(this.x1x0pow2 + this.y1y0pow2);
        if (this.coords[2] < this.coords[5]) {
            rmin = this.coords[2];
            rmax = this.coords[5];
        } else {
            rmin = this.coords[5];
            rmax = this.coords[2];
        }
        if (centerToCenter + rmin <= rmax) {
            return 2.0 * rmax;
        }
        return rmin + centerToCenter + (double)this.coords[5];
    }

    private int[] calcColorTable() {
        int[] map = new int[(int)this.longestDistance + 1];
        if (this.longestDistance == 0.0 || this.d1d0 == 0.0f) {
            try {
                float[] values = this.radialShadingType.evalFunction(this.domain[0]);
                map[0] = this.convertToRGB(values);
            }
            catch (IOException exception) {
                LOG.error((Object)"error while processing a function", (Throwable)exception);
            }
        } else {
            int i = 0;
            while ((double)i <= this.longestDistance) {
                float t = this.domain[0] + this.d1d0 * (float)i / (float)this.longestDistance;
                try {
                    float[] values = this.radialShadingType.evalFunction(t);
                    map[i] = this.convertToRGB(values);
                }
                catch (IOException exception) {
                    LOG.error((Object)"error while processing a function", (Throwable)exception);
                }
                ++i;
            }
        }
        return map;
    }

    @Override
    public void dispose() {
        this.outputColorModel = null;
        this.radialShadingType = null;
        this.shadingColorSpace = null;
        this.shadingTinttransform = null;
    }

    @Override
    public ColorModel getColorModel() {
        return this.outputColorModel;
    }

    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
        float inputValue = -1.0f;
        int[] data = new int[w * h * 4];
        for (int j = 0; j < h; ++j) {
            double currentY = y + j;
            if (this.bboxRect != null && (currentY < (double)this.minBBoxY || currentY > (double)this.maxBBoxY)) continue;
            for (int i = 0; i < w; ++i) {
                int value;
                double currentX = x + i;
                if (this.bboxRect != null && (currentX < (double)this.minBBoxX || currentX > (double)this.maxBBoxX)) continue;
                boolean useBackground = false;
                float[] inputValues = this.calculateInputValues(x + i, y + j);
                if (Float.isNaN(inputValues[0]) && Float.isNaN(inputValues[1])) {
                    if (this.background == null) continue;
                    useBackground = true;
                } else {
                    if (inputValues[0] >= 0.0f && inputValues[0] <= 1.0f) {
                        inputValue = inputValues[1] >= 0.0f && inputValues[1] <= 1.0f ? Math.max(inputValues[0], inputValues[1]) : inputValues[0];
                    } else if (inputValues[1] >= 0.0f && inputValues[1] <= 1.0f) {
                        inputValue = inputValues[1];
                    } else if (this.extend[0] && this.extend[1]) {
                        inputValue = Math.max(inputValues[0], inputValues[1]);
                    } else if (this.extend[0]) {
                        inputValue = inputValues[0];
                    } else if (this.extend[1]) {
                        inputValue = inputValues[1];
                    } else {
                        if (this.background == null) continue;
                        useBackground = true;
                    }
                    if (inputValue > 1.0f) {
                        if (this.extend[1] && this.coords[5] > 0.0f) {
                            inputValue = 1.0f;
                        } else {
                            if (this.background == null) continue;
                            useBackground = true;
                        }
                    } else if (inputValue < 0.0f) {
                        if (this.extend[0] && this.coords[2] > 0.0f) {
                            inputValue = 0.0f;
                        } else {
                            if (this.background == null) continue;
                            useBackground = true;
                        }
                    }
                }
                if (useBackground) {
                    value = this.rgbBackground;
                } else {
                    int key = (int)((double)inputValue * this.longestDistance);
                    value = this.colorTable[key];
                }
                int index = (j * w + i) * 4;
                data[index] = value & 0xFF;
                data[index + 1] = (value >>= 8) & 0xFF;
                data[index + 2] = (value >>= 8) & 0xFF;
                data[index + 3] = 255;
            }
        }
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }

    private float[] calculateInputValues(int x, int y) {
        double p = (double)(-((float)x - this.coords[0])) * this.x1x0 - (double)((float)y - this.coords[1]) * this.y1y0 - (double)this.coords[2] * this.r1r0;
        double q = Math.pow((float)x - this.coords[0], 2.0) + Math.pow((float)y - this.coords[1], 2.0) - this.r0pow2;
        double root = Math.sqrt(p * p - this.denom * q);
        float root1 = (float)((-p + root) / this.denom);
        float root2 = (float)((-p - root) / this.denom);
        if (this.denom < 0.0) {
            return new float[]{root1, root2};
        }
        return new float[]{root2, root1};
    }

    public float[] getCoords() {
        return this.coords;
    }

    public float[] getDomain() {
        return this.domain;
    }

    public boolean[] getExtend() {
        return this.extend;
    }

    public PDFunction getFunction() throws IOException {
        return this.radialShadingType.getFunction();
    }
}

